/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.mapping;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.model.Shape;
import filenet.vw.toolkit.design.visio.model.mapping.VWContainerItem;
import filenet.vw.toolkit.design.visio.model.mapping.VWLaneItem;
import filenet.vw.toolkit.design.visio.model.mapping.VWMapItem;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingHelper;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

class VWProcessItem
extends VWContainerItem {
    private VWWorkflowDefinition m_myWflDef = null;
    private String m_defaultMapName = null;
    private Vector m_myMapItems = null;
    private Vector m_myLaneItems = null;

    protected VWProcessItem(Shape myShape, VWWorkflowDefinition myWflDef) {
        super(myShape);
        this.m_myWflDef = myWflDef;
        this.m_myLaneItems = new Vector();
        try {
            VWMapDefinition vwMapDef = this.m_myWflDef.getMainMap();
            VWMapItem mapItem = new VWMapItem(null, vwMapDef);
            this.m_defaultMapName = vwMapDef.getName();
            this.m_myMapItems = new Vector();
            this.m_myMapItems.addElement(mapItem);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    protected String getName() {
        if (this.m_myWflDef != null) {
            return this.m_myWflDef.getName();
        }
        return null;
    }

    protected void setDefaultMapName(String defaultMapName) {
        this.m_defaultMapName = defaultMapName;
    }

    protected void rejustifyItems() {
        for (int nIndex = 0; nIndex < this.m_myMapItems.size(); ++nIndex) {
            VWMapItem mapItem = (VWMapItem)this.m_myMapItems.elementAt(nIndex);
            mapItem.rejustifyItems();
        }
    }

    protected Vector setFields(Vector fieldList, VWMappingHelper mappingHelper) {
        Vector[] shapeLists = this.findContainedShapes(fieldList);
        if (shapeLists != null) {
            Vector myFieldList = shapeLists[0];
            if (myFieldList != null) {
                for (int nIndex = 0; nIndex < myFieldList.size(); ++nIndex) {
                    Shape shape = (Shape)myFieldList.elementAt(nIndex);
                    this.addField(shape, mappingHelper);
                }
            }
            return shapeLists[1];
        }
        return fieldList;
    }

    protected Vector setSteps(Vector stepList, VWMappingHelper mappingHelper) {
        Vector[] shapeLists = this.findContainedShapes(stepList);
        if (shapeLists != null) {
            Vector myStepList = shapeLists[0];
            if (myStepList != null && myStepList.size() > 0) {
                int nIndex;
                VWMapItem myMapItem;
                block2: for (int nIndex2 = 0; nIndex2 < myStepList.size(); ++nIndex2) {
                    Shape shape = (Shape)myStepList.elementAt(nIndex2);
                    String fnObjectName = shape.getDesignerObjectName();
                    if (VWStringUtils.compare(fnObjectName, VWResource.s_submap) == 0) {
                        String mapName = shape.getText();
                        try {
                            if (mapName == null || mapName.length() == 0) {
                                mapName = VWResource.s_map + this.m_myWflDef.getMaps().length;
                            }
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                        }
                        shape.setSubmapName(mapName);
                        this.addMap(shape, mapName, mappingHelper);
                        continue;
                    }
                    if (VWStringUtils.compare(shape.getNameU(), "Off-page reference") != 0) continue;
                    for (int nIdx2 = 0; nIdx2 < this.m_myMapItems.size(); ++nIdx2) {
                        VWMapItem myMapItem2 = (VWMapItem)this.m_myMapItems.elementAt(nIdx2);
                        if (!myMapItem2.hasReferencedShapes(shape)) continue;
                        this.m_defaultMapName = myMapItem2.getName();
                        continue block2;
                    }
                }
                int nDefaultMapItemIndex = this.findMapItem(null, this.m_defaultMapName);
                if (nDefaultMapItemIndex == -1) {
                    nDefaultMapItemIndex = this.addMap(null, this.m_defaultMapName, mappingHelper);
                }
                if (nDefaultMapItemIndex > 1 && (myMapItem = (VWMapItem)this.m_myMapItems.elementAt(nDefaultMapItemIndex)) != null) {
                    this.m_myMapItems.removeElementAt(nDefaultMapItemIndex);
                    this.m_myMapItems.insertElementAt(myMapItem, 1);
                }
                Vector copyOfMyStepList = (Vector)myStepList.clone();
                for (nIndex = this.m_myMapItems.size() - 1; nIndex >= 0; --nIndex) {
                    VWMapItem myMapItem3 = (VWMapItem)this.m_myMapItems.elementAt(nIndex);
                    myStepList = myMapItem3.setSteps(myStepList, mappingHelper);
                }
                for (nIndex = 0; nIndex < this.m_myLaneItems.size(); ++nIndex) {
                    VWLaneItem myLaneItem = (VWLaneItem)this.m_myLaneItems.elementAt(nIndex);
                    copyOfMyStepList = myLaneItem.setSteps(copyOfMyStepList, mappingHelper);
                }
            }
            return shapeLists[1];
        }
        return stepList;
    }

    protected Vector setStartSteps(Vector startStepList) {
        Vector[] shapeLists = this.findContainedShapes(startStepList);
        if (shapeLists != null) {
            Vector myStartStepList = shapeLists[0];
            if (myStartStepList != null && myStartStepList.size() > 0) {
                for (int nIndex = this.m_myMapItems.size() - 1; nIndex >= 0; --nIndex) {
                    VWMapItem myMapItem = (VWMapItem)this.m_myMapItems.elementAt(nIndex);
                    myStartStepList = myMapItem.setStartSteps(myStartStepList);
                }
            }
            return shapeLists[1];
        }
        return startStepList;
    }

    protected Vector setRoutes(Vector routeList) {
        Vector[] shapeLists = this.findContainedShapes(routeList);
        if (shapeLists != null) {
            Vector myRouteList = shapeLists[0];
            if (myRouteList != null && myRouteList.size() > 0) {
                for (int nIndex = this.m_myMapItems.size() - 1; nIndex >= 0; --nIndex) {
                    VWMapItem myMapItem = (VWMapItem)this.m_myMapItems.elementAt(nIndex);
                    myRouteList = myMapItem.setRoutes(myRouteList);
                }
            }
            return shapeLists[1];
        }
        return routeList;
    }

    protected Vector setTextAnnotations(Vector textAnnotationList) {
        Vector[] shapeLists = this.findContainedShapes(textAnnotationList);
        if (shapeLists != null) {
            Vector myTextAnnotationList = shapeLists[0];
            if (myTextAnnotationList != null && myTextAnnotationList.size() > 0) {
                for (int nIndex = this.m_myMapItems.size() - 1; nIndex >= 0; --nIndex) {
                    VWMapItem myMapItem = (VWMapItem)this.m_myMapItems.elementAt(nIndex);
                    myTextAnnotationList = myMapItem.setTextAnnotations(myTextAnnotationList);
                }
            }
            return shapeLists[1];
        }
        return textAnnotationList;
    }

    protected Vector setAssociations(Vector associationList) {
        Vector[] shapeLists = this.findContainedShapes(associationList);
        if (shapeLists != null) {
            Vector myAssociationList = shapeLists[0];
            if (myAssociationList != null && myAssociationList.size() > 0) {
                for (int nIndex = this.m_myMapItems.size() - 1; nIndex >= 0; --nIndex) {
                    VWMapItem myMapItem = (VWMapItem)this.m_myMapItems.elementAt(nIndex);
                    myAssociationList = myMapItem.setAssociations(myAssociationList);
                }
            }
            return shapeLists[1];
        }
        return associationList;
    }

    protected void convertShapes(VWMappingHelper mappingHelper, int nPageHeight) {
        int nIndex;
        for (nIndex = 0; nIndex < this.m_myMapItems.size(); ++nIndex) {
            VWMapItem myMapItem = (VWMapItem)this.m_myMapItems.elementAt(nIndex);
            myMapItem.convertShapes(mappingHelper, nPageHeight);
            myMapItem.resetMode();
        }
        for (nIndex = 0; nIndex < this.m_myLaneItems.size(); ++nIndex) {
            VWLaneItem myLaneItem = (VWLaneItem)this.m_myLaneItems.elementAt(nIndex);
            myLaneItem.convertShapes(mappingHelper, nPageHeight);
        }
        this.m_myLaneItems = new Vector();
    }

    private void addField(Shape shape, VWMappingHelper mappingHelper) {
        String name = this.makeValidFieldName(shape.getText());
        String value = null;
        int nType = -1;
        boolean bIsArray = false;
        String typeStr = null;
        if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_attachment) == 0) {
            VWAttachment vwAtt = new VWAttachment();
            value = "\"" + vwAtt.toString() + "\"";
            nType = 32;
        } else if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_dataField) == 0) {
            value = "\"\"";
            nType = 2;
        } else if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_workflowGroup) == 0) {
            value = "{\"\"}";
            nType = 64;
            bIsArray = true;
            typeStr = VWResource.s_workflowGroup;
            this.m_myLaneItems.addElement(new VWLaneItem(shape));
        } else if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_xmlDataField) == 0) {
            value = "\"\"";
            nType = 128;
        }
        if (name != null && value != null && nType != -1) {
            try {
                VWFieldDefinition fieldDef = this.m_myWflDef.getField(name);
                shape.setApiObject(fieldDef);
            }
            catch (VWException ex) {
                try {
                    VWFieldDefinition fieldDef = this.m_myWflDef.createFieldUsingString(name, value, nType, bIsArray);
                    shape.setApiObject(fieldDef);
                    if (typeStr == null) {
                        typeStr = VWFieldType.getLocalizedString(nType);
                    }
                    mappingHelper.addMessage(1, VWResource.s_addedField.toString(typeStr, name));
                }
                catch (VWException ex2) {
                    mappingHelper.addMessage(2, VWResource.s_errorCreatingField.toString(name));
                }
            }
        }
    }

    private String makeValidFieldName(String fieldName) {
        try {
            if (fieldName == null || fieldName.trim().length() == 0) {
                int nIndex = 0;
                if (this.m_myWflDef.getFields() != null) {
                    nIndex = this.m_myWflDef.getFields().length;
                }
                fieldName = VWResource.s_field + nIndex;
            }
            if (fieldName != null) {
                fieldName = fieldName.replace(' ', '_');
                StringBuffer buffer = new StringBuffer();
                for (int nIndex = 0; nIndex < fieldName.length(); ++nIndex) {
                    char ch = fieldName.charAt(nIndex);
                    if (!Character.isLetterOrDigit(ch) && ch != '_') continue;
                    buffer.append(ch);
                }
                fieldName = buffer.toString();
                if (fieldName.length() == 0 || !Character.isLetter(fieldName.charAt(0))) {
                    fieldName = VWResource.s_field + fieldName;
                } else if (fieldName.length() > 128) {
                    fieldName = fieldName.substring(0, 128);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return fieldName;
    }

    private int addMap(Shape shape, String mapName, VWMappingHelper mappingHelper) {
        try {
            int nIndex = this.findMapItem(shape, mapName);
            if (nIndex != -1) {
                return nIndex;
            }
            VWMapDefinition newMapDef = this.m_myWflDef.createMap(mapName);
            if (newMapDef != null) {
                mappingHelper.addMessage(1, VWResource.s_addedMap.toString(mapName));
                VWMapItem newMapItem = new VWMapItem(shape, newMapDef);
                if (newMapItem != null) {
                    this.m_myMapItems.addElement(newMapItem);
                    return this.m_myMapItems.size() - 1;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    private int findMapItem(Shape shape, String mapName) {
        for (int nIndex = 0; nIndex < this.m_myMapItems.size(); ++nIndex) {
            VWMapItem myMapItem = (VWMapItem)this.m_myMapItems.elementAt(nIndex);
            if (VWStringUtils.compare(myMapItem.getName(), mapName) != 0) continue;
            myMapItem.setShape(shape);
            return nIndex;
        }
        try {
            VWMapItem newMapItem;
            VWMapDefinition mapDef = this.m_myWflDef.getMap(mapName);
            if (mapDef != null && (newMapItem = new VWMapItem(shape, mapDef)) != null) {
                this.m_myMapItems.addElement(newMapItem);
                return this.m_myMapItems.size() - 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }
}

